//This code has the mode select commented out as well as the slider code
//The result is a faster joysticks code. There's a delay function that we use to
// slow the movemement of the arm down.
// Idle is also set at 100 which probably needs adjusting to stop the servos timing out so quickly.

//#include <Servo.h> 
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_PCD8544.h>

// Hardware SPI (faster, but must use certain hardware pins):
// SCK is LCD serial clock (SCLK) - this is pin 13 on Arduino Uno
// MOSI is LCD DIN - this is pin 11 on an Arduino Uno
// pin 4 - Data/Command select (D/C)
// pin 8 - LCD chip select (CS)
// pin 7 - LCD reset (RST)
Adafruit_PCD8544 display = Adafruit_PCD8544(4, 8, 7);//updated MeArm Pins
// Note with hardware SPI MISO and SS pins aren't used but will still be read
// and written to during SPI transfer.  Be careful sharing these pins!

#define XPOS 0
#define YPOS 1

const int SERVOS = 4;
const int ACC = 10; // the accurancy of the potentiometer value before idle starts counting
int PIN[SERVOS], value[SERVOS], idle[SERVOS], currentAngle[SERVOS], MIN[SERVOS], MAX[SERVOS], INITANGLE[SERVOS], previousAngle[SERVOS],ANA[SERVOS];
//Servo myservo[SERVOS];
//int modePin = 3;
//int mode = LOW; // mode stores button push to change between Joysticks and Sliders

#define LOGO16_GLCD_HEIGHT 16
#define LOGO16_GLCD_WIDTH  16

/*static const unsigned char PROGMEM logo16_glcd_bmp[] =
{ B00000000, B11000000,
  B00000001, B11000000,
  B00000001, B11000000,
  B00000011, B11100000,
  B11110011, B11100000,
  B11111110, B11111000,
  B01111110, B11111111,
  B00110011, B10011111,
  B00011111, B11111100,
  B00001101, B01110000,
  B00011011, B10100000,
  B00111111, B11100000,
  B00111111, B11110000,
  B01111100, B11110000,
  B01110000, B01110000,
  B00000000, B00110000 };
*/

void setup()   {
  Serial.begin(57600);
//  int mode = LOW; 
//  pinMode(modePin, INPUT); // Enables button for Mode Change on Startup
  display.begin();
  // init done
  // you can change the contrast around to adapt the display
  // for the best viewing!
  display.setContrast(50);
  display.display(); // show splashscreen
  display.clearDisplay(); 
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
//  display.println("To Use Sliders");
//  display.println("Hold Right Button");
//  display.println("Else");
  display.println("Greetings");
  display.println("");
  display.println("from MeArm.com");
  display.display(); // show splashscreen
  delay(5000);
  display.clearDisplay();   // clears the screen and buffer
}
  
  
  void loop() {
  	
      value[0] = analogRead(ANA[0]);
      currentAngle[0]=map(value[0], 0, 1023, 0, 127);
    
  display.setContrast(currentAngle[0]);
  display.clearDisplay();
  display.setTextSize(1);
  display.setTextColor(BLACK);
  display.setCursor(0,0);
  display.println("This is the");
  display.println("Contrast=.");
  display.print(currentAngle[0]);
  display.println("MeArm.io");
//  display.println(idle[1]);
  
//  Display Potentiometer Values on LCD (Slows MeArm Down too)
//  display.print(value[0]);
//  display.print(";");
//  display.print(value[1]);
//  display.print(";");
//  display.print(value[2]);
//  display.print(";");
//  display.println(value[3]);
  

  display.display();
  
}



/*********************************************************************
This is an example sketch for our Monochrome Nokia 5110 LCD Displays

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/338

These displays use SPI to communicate, 4 or 5 pins are required to
interface

Adafruit invests time and resources providing this open source code,
please support Adafruit and open-source hardware by purchasing
products from Adafruit!

Written by Limor Fried/Ladyada  for Adafruit Industries.
BSD license, check license.txt for more information
All text above, and the splash screen must be included in any redistribution
*********************************************************************/