/* File:      TTP229
   Date:      2015. aug. 19.
   Copyright: "As Is"
   Contact:   Robert Cseh (csehrobert@tavir.hu) 
   
   Rev.:      0.1 (Beta)
This is an example of how to use TTP229 16 key capacitive touch keypad.
This example sketch will read the current state of the of the keypad and output
its key number to the serial port.

The sketch assumes that the keypad is configured to 16 key active low mode
by shorting pads P1-3 and P1-4 together (see schematic for more
information). Connect the keypad to your Arduino as follows:

Keypad......Arduino
VCC.........+5V
GND.........GND
SCL.........Digital pin 7
SDO.........Digital pin 2

No Warranty. The Software is provided "as is" without warranty
of any kind, either express or implied, including without limitation
any implied warranties of condition, uninterrupted use, merchantability,
fitness for a particular purpose, or non-infringement. */



/* Define the digital pins used for the clock and data */
#define SCL_PIN 7
#define SDO_PIN 2

/* Used to store the key state */
byte Key;

void setup()
{
  /* Initialise the serial interface */
  Serial.begin(9600);
  /* Configure the clock and data pins */
  pinMode(SCL_PIN, OUTPUT); 
  pinMode(SDO_PIN, INPUT);
}


/* Main program */
void loop()
{
  /* Read the current state of the keypad */
  Key = Read_Keypad();
 
  /* If a key has been pressed output it to the serial port */
  if (Key)
    Serial.println(Key);

  /* Wait a little before reading again
     so not to flood the serial port*/
  delay(100);
}


/* Read the state of the keypad */
byte Read_Keypad(void)
{
  byte Count;
  byte Key_State = 0;

  /* Pulse the clock pin 16 times (one for each key of the keypad)
     and read the state of the data pin on each pulse */
  for(Count = 1; Count <= 16; Count++)
  {
    digitalWrite(SCL_PIN, LOW);
   
    /* If the data pin is low (active low mode) then store the
       current key number */
    if (!digitalRead(SDO_PIN))
      Key_State = Count;
   
    digitalWrite(SCL_PIN, HIGH);
  } 
 
  return Key_State;
}
