/* FILE:    HCMAX7219.cpp
   DATE:    19/03/15
   VERSION: 0.2
   AUTHOR:  Andrew Davies

11/03/15 version 0.1: Original version

19/03/15 version 0.2: Added support for serial dot matrix module HCOPTO0014
					  and made speed enhancements by using hardware SPI 
					  interface.
   
   
Library for Maxim MAX7219 LED driver IC.

You may copy, alter and reuse this code in any way you like, but please leave
reference to HobbyComponents.com in your comments if you redistribute this code.
This software may not be used directly for the purpose of selling products that
directly compete with Hobby Components Ltd's own range of products.

THIS SOFTWARE IS PROVIDED "AS IS". HOBBY COMPONENTS MAKES NO WARRANTIES, WHETHER
EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ACCURACY OR LACK OF NEGLIGENCE.
HOBBY COMPONENTS SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR ANY DAMAGES,
INCLUDING, BUT NOT LIMITED TO, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY
REASON WHATSOEVER.
*/

#ifndef HCMAX7219_h
#define HCMAX7219_h
#include "Arduino.h"

/***************************** USER CONFIGURATION ****************************/

/* CHANGE THIS VALUE IF YOU ARE DASY CHAINING MORE THAN ONE DRIVER */
#define NUMBEROFDRIVERS 1


/* TO SAVE PROGRAM MEMORY COMMENT OUT ANY OF THE LINES BELOW FOR HARDWARE THAT'S
   NOT BEING USED */
#define SEVENSEGMENT //Seven segment display module HCMODU0082
#define DOTMATRIX //8x8 serial dot matrix module HCOPTO0014

/*****************************************************************************/


/* Defines the size of the output buffer */
#define DISPLAYBUFFERSIZE NUMBEROFDRIVERS * 8

/* MAX7219 register addresses */
#define MAX7219NOOP 0x00
#define MAX7219DIGIT1 0x01
#define MAX7219DIGIT2 0x02
#define MAX7219DIGIT3 0x03
#define MAX7219DIGIT4 0x04
#define MAX7219DIGIT5 0x05
#define MAX7219DIGIT6 0x06
#define MAX7219DIGIT7 0x07
#define MAX7219DIGIT8 0x08
#define MAX7219DECODE 0x09
#define MAX7219INTESITY 0x0A
#define MAX7219SCANLIMIT 0x0B
#define MAX7219SHUTDOWN 0x0C
#define MAX7219TEST 0x0F

/* MAX7219 register options */
#define TESTMODEOFF 0
#define TESTMODEON 1
#define MAX7219OFF 0
#define MAX7219ON 1

/* Other Options */
#define INVERTOFF 0
#define INVERTON 0xFF

/* Character map for seven-segment display */
#ifdef SEVENSEGMENT
const byte SevenSegChar[101] = {0x00, // SPACE
                               0xA0, // !
                               0x22, // "
                               0x36, // #
                               0x4B, // $
                               0x5A, // %
                               0x6F, // &
                               0x02, // '
                               0x4E, // (
                               0x78, // )
                               0x63, // *
                               0x07, // +
                               0x18, // ,
                               0x01, // -
                               0x80, // .
                               0x25, // / 
                               0x7E, // 0
                               0x30, // 1
                               0x6D, // 2
                               0x79, // 3
                               0x33, // 4
                               0x5B, // 5
                               0x5F, // 6
                               0x70, // 7
                               0x7F, // 8        
                               0x7B, // 9
                               0x09, // :
                               0x19, // ;
                               0x43, // <
                               0x41, // =
                               0x61, // >
                               0x65, // ?
                               0x7D, // @
                               0x77, // A
                               0x1F, // B
                               0x4E, // C
                               0x3D, // D
                               0x4F, // E
                               0x47, // F
                               0x5E, // G
                               0x37, // H
                               0x30, // I
                               0x38, // J
                               0x57, // K
                               0x0E, // L
                               0x54, // M
                               0x76, // N
                               0x7E, // O
                               0x67, // P
                               0x73, // Q
                               0x66, // R
                               0x5B, // S
                               0x0F, // T
                               0x3E, // U
                               0x3A, // V
                               0x2A, // W
                               0x37, // X
                               0x3B, // Y
                               0x69, // Z
                               0x4E, // [
                               0x13, // |
                               0x78, // ]
                               0x62, // ^
                               0x08, // _ 
                               0x02, // '      
                               0x77, // a
                               0x1F, // b
                               0x4E, // c
                               0x3D, // d
                               0x4F, // e
                               0x47, // f
                               0x5E, // g
                               0x37, // h
                               0x30, // i
                               0x38, // j
                               0x57, // k
                               0x0E, // l
                               0x54, // m
                               0x76, // n
                               0x7E, // o
                               0x67, // p
                               0x73, // q
                               0x66, // r
                               0x5B, // s
                               0x0F, // t
                               0x3E, // u
                               0x3A, // v
                               0x2A, // w
                               0x37, // x
                               0x3B, // y
                               0x69}; // z                          
#endif

#ifdef SEVENSEGMENT
const char Font8x8[][8] = 
{ {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0xF2,0xF2,0x00,0x00,0x00},
  {0x00,0xE0,0xE0,0x00,0x00,0xE0,0xE0,0x00},
  {0x28,0xFE,0xFE,0x28,0x28,0xFE,0xFE,0x28},
  {0x00,0x24,0x74,0xD6,0xD6,0x5C,0x48,0x00},
  {0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00},
  {0x00,0x4C,0xFE,0xB2,0xB2,0xEE,0x4E,0x0A},
  {0x00,0x00,0x00,0x20,0x60,0xC0,0x80,0x00},
  {0x00,0x00,0x38,0x7C,0xC6,0x82,0x00,0x00},
  {0x00,0x00,0x82,0xC6,0x7C,0x38,0x00,0x00},
  {0x10,0x54,0x7C,0x38,0x38,0x7C,0x54,0x10},
  {0x00,0x10,0x10,0x7C,0x7C,0x10,0x10,0x00},
  {0x00,0x00,0x01,0x07,0x06,0x00,0x00,0x00},
  {0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
  {0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00},
  {0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0x40},
  {0x00,0x7C,0xFE,0x92,0xA2,0xFE,0x7C,0x00},
  {0x00,0x02,0x22,0xFE,0xFE,0x02,0x02,0x00},
  {0x00,0x46,0xCE,0x8A,0x92,0xF2,0x62,0x00},
  {0x00,0x44,0xC6,0x92,0x92,0xFE,0x6C,0x00},
  {0x00,0x18,0x18,0x28,0x68,0xFE,0xFE,0x08},
  {0x00,0xE4,0xE6,0xA2,0xA2,0xBE,0x9C,0x00},
  {0x00,0x7C,0xFE,0x92,0x92,0xDE,0x4C,0x00},
  {0x00,0xC0,0xC0,0x9E,0xBE,0xE0,0xC0,0x00},
  {0x00,0x6C,0xFE,0x92,0x92,0xFE,0x6C,0x00},
  {0x00,0x64,0xF6,0x92,0x92,0xFE,0x7C,0x00},
  {0x00,0x00,0x00,0x24,0x24,0x00,0x00,0x00},
  {0x00,0x00,0x01,0x27,0x26,0x00,0x00,0x00},
  {0x00,0x10,0x38,0x6C,0xC6,0x82,0x82,0x00},
  {0x00,0x28,0x28,0x28,0x28,0x28,0x28,0x00},
  {0x00,0x82,0x82,0xC6,0x6C,0x38,0x10,0x00},
  {0x00,0x40,0xC0,0x8A,0x9A,0xF0,0x60,0x00},
  {0x00,0x7C,0xFE,0x82,0xB2,0xF2,0x74,0x00},
  {0x00,0x3E,0x7E,0xD0,0xD0,0x7E,0x3E,0x00},
  {0x00,0xFE,0xFE,0x92,0x92,0xFE,0x6C,0x00},
  {0x00,0x7C,0xFE,0x82,0x82,0xC6,0x44,0x00},
  {0x00,0xFE,0xFE,0x82,0xC6,0x7C,0x38,0x00},
  {0x00,0xFE,0xFE,0x92,0x92,0x82,0x82,0x00},
  {0x00,0xFE,0xFE,0x90,0x90,0x80,0x80,0x00},
  {0x00,0x7C,0xFE,0x82,0x92,0xDE,0x5C,0x00},
  {0x00,0xFE,0xFE,0x10,0x10,0xFE,0xFE,0x00},
  {0x00,0x00,0x82,0xFE,0xFE,0x82,0x00,0x00},
  {0x00,0x04,0x06,0x82,0xFE,0xFC,0x80,0x00},
  {0x00,0xFE,0xFE,0x38,0x6C,0xC6,0x82,0x00},
  {0x00,0xFE,0xFE,0x02,0x02,0x02,0x02,0x00},
  {0x00,0xFE,0xFE,0x60,0x30,0x60,0xFE,0xFE},
  {0x00,0xFE,0xFE,0x70,0x38,0xFE,0xFE,0x00},
  {0x00,0x7C,0xFE,0x82,0x82,0xFE,0x7C,0x00},
  {0x00,0xFE,0xFE,0x90,0x90,0xF0,0x60,0x00},
  {0x00,0x78,0xFC,0x84,0x86,0xFE,0x7A,0x00},
  {0x00,0xFE,0xFE,0x98,0x9C,0xF6,0x62,0x00},
  {0x00,0x64,0xF6,0x92,0x92,0xDE,0x4C,0x00},
  {0x00,0x80,0x80,0xFE,0xFE,0x80,0x80,0x00},
  {0x00,0xFC,0xFE,0x02,0x02,0xFE,0xFC,0x00},
  {0x00,0xF8,0xFC,0x06,0x06,0xFC,0xF8,0x00},
  {0x00,0xFE,0xFE,0x0C,0x18,0x0C,0xFE,0xFE},
  {0x00,0xC6,0xEE,0x38,0x38,0xEE,0xC6,0x00},
  {0x00,0xE0,0xF0,0x1E,0x1E,0xF0,0xE0,0x00},
  {0x00,0x86,0x8E,0x9A,0xB2,0xE2,0xC2,0x00},
  {0x00,0x00,0xFE,0xFE,0x82,0x82,0x00,0x00},
  {0x00,0x40,0x60,0x30,0x18,0x0C,0x06,0x02},
  {0x00,0x00,0x82,0x82,0xFE,0xFE,0x00,0x00},
  {0x00,0x18,0x30,0x60,0xC0,0x60,0x30,0x18},
  {0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01},
  {0x00,0x00,0x80,0x40,0x20,0x00,0x00,0x00},
  {0x00,0x04,0x2E,0x2A,0x2A,0x3E,0x1E,0x00},
  {0x00,0x7E,0x7E,0x12,0x12,0x1E,0x0C,0x00},
  {0x00,0x1C,0x3E,0x22,0x22,0x22,0x00,0x00},
  {0x00,0x0C,0x1E,0x12,0x12,0x7E,0x7E,0x00},
  {0x00,0x1C,0x3E,0x2A,0x2A,0x3A,0x18,0x00},
  {0x00,0x10,0x3E,0x7E,0x50,0x50,0x00,0x00},
  {0x00,0x19,0x3D,0x25,0x25,0x3F,0x3E,0x00},
  {0x00,0x7E,0x7E,0x10,0x10,0x1E,0x0E,0x00},
  {0x00,0x00,0x12,0x5E,0x5E,0x02,0x00,0x00},
  {0x00,0x00,0x01,0x01,0x01,0x5F,0x5E,0x00},
  {0x00,0x7E,0x7E,0x08,0x1C,0x16,0x02,0x00},
  {0x00,0x00,0x42,0x7E,0x7E,0x02,0x00,0x00},
  {0x00,0x3E,0x3E,0x18,0x1C,0x38,0x3E,0x1E},
  {0x00,0x3E,0x3E,0x20,0x20,0x3E,0x1E,0x00},
  {0x00,0x1C,0x3E,0x22,0x22,0x3E,0x1C,0x00},
  {0x00,0x3F,0x3F,0x24,0x24,0x3C,0x18,0x00},
  {0x00,0x18,0x3C,0x24,0x24,0x3F,0x3F,0x00},
  {0x00,0x3E,0x3E,0x20,0x20,0x30,0x10,0x00},
  {0x00,0x12,0x3A,0x2A,0x2A,0x2E,0x24,0x00},
  {0x00,0x20,0x20,0x7C,0x7E,0x22,0x22,0x00},
  {0x00,0x3C,0x3E,0x02,0x02,0x3E,0x3E,0x00},
  {0x00,0x38,0x3C,0x06,0x06,0x3C,0x38,0x00},
  {0x00,0x38,0x3E,0x0E,0x1C,0x0E,0x3E,0x38},
  {0x00,0x22,0x36,0x1C,0x1C,0x36,0x22,0x00},
  {0x00,0x39,0x3D,0x05,0x07,0x3E,0x3C,0x00},
  {0x00,0x22,0x26,0x2E,0x3A,0x32,0x22,0x00},
  {0x00,0x00,0x10,0x7C,0xEE,0x82,0x00,0x00},
  {0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00},
  {0x00,0x00,0x82,0xEE,0x7C,0x10,0x00,0x00},
  {0x00,0x08,0x10,0x10,0x18,0x08,0x08,0x10}
};
#endif



class HCMAX7219
{
  public:
  HCMAX7219(byte LOAD);
  void Write(byte Address, byte Data, byte Driver);
  void Shutdown(boolean Mode, byte Driver);
  void TestMode(boolean Mode, byte Driver);
  void SevenSegDigits(byte Digits, byte Driver);
  void Intensity(byte Level, byte Driver);
  void Clear(void);
  void Refresh(void);

#ifdef SEVENSEGMENT
  void print7Seg(char TextString[], unsigned int Offset);
  void print7Seg(long number, unsigned int Offset);
  void print7Seg(long number, byte decimalPlace, unsigned int Offset);
#endif  

#ifdef DOTMATRIX
  void printMatrix(char TextString[], unsigned int Offset);
  void printMatrix(long number, byte decimalPlace, unsigned int Offset);
  void printMatrix(long number, unsigned int Offset);
#endif

#ifdef DOTMATRIX
  void Invert(byte InvertState);
#endif
 
  byte DisplayBuffer[DISPLAYBUFFERSIZE];
  
  private:
  void Init(void);
  int CalCharIndex(int Offset); 
  byte _LOAD;
  byte _InvertState;
};  


#endif