Code:
/* FILE:    HX711_Bridge_Sensor_Digital_Interface_Module
   DATE:    28/08/14
   VERSION: 0.1
   AUTHOR:  Andrew Davies

This is a basic example of how to use the HX711 dual channel bridge sensor interface 
module (HCMODU0073). By default the sketch will configure the module to take 
measurements from the channel A input with a gain of 64. These measurements will be 
repeatedly triggered at its maximum rate and the result output to a serial terminal.

PINOUT:

Module.....Uno/Nano
GND........GND
DT.........D9
SCK........D8
VCC........+5V


You may copy, alter and reuse this code in any way you like, but please leave
reference to HobbyComponents.com in your comments if you redistribute any part of 
this code. This software may not be used for the purpose of promoting products
that directly compete with Hobby Components Ltd's own range of products.

THIS SOFTWARE IS PROVIDED "AS IS". HOBBY COMPONENTS MAKES NO WARRANTIES, WHETHER
EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ACCURACY OR LACK OF NEGLIGENCE.
HOBBY COMPONENTS SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR ANY DAMAGES,
INCLUDING, BUT NOT LIMITED TO, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY
REASON WHATSOEVER.
*/


/* Define digital pins used for the clock and data signals. */
#define PD_SCK 8
#define DOUT 9

/* Define the various gain and input options */
#define CHAN_A_GAIN_128 1
#define CHAN_B_GAIN_32 2
#define CHAN_A_GAIN_64 3


void setup()
{
  Serial.begin(9600);
  
  /* Set the clock pin to and output and the digital pin to an input */
  pinMode(PD_SCK, OUTPUT);
  pinMode(DOUT, INPUT);
  
   /* Take the device out of power down mode (clock pin low) */
  digitalWrite(PD_SCK, LOW);
  
  /* Trigger a conversion so that the module is in the correct mode for 
     the next measurement */
  ReadConversion(CHAN_A_GAIN_64);
}

/* Main program loop */
void loop()
{
  /* Read in the last measurement and output to the serial port */
  Serial.println(ReadConversion(CHAN_A_GAIN_64));
}


/* Function to read a measurement from the module. 
   The result is returned as a 32 bit signed integer */
long ReadConversion(byte ConversionMode)
{
  byte index;
  long ConversionData = 0L;
  
  /* Read in the 24 bit conversion data */
  while(digitalRead(DOUT));
  for (index = 0; index < 24; index++)
  {
    digitalWrite(PD_SCK, HIGH);
    ConversionData =  (ConversionData << 1) | digitalRead(DOUT);
    digitalWrite(PD_SCK, LOW);
  }
  
  /* Output some extra clock cycles to set the gain and input options */
  for (index = 0; index < ConversionMode; index++)
  {
    digitalWrite(PD_SCK, HIGH);
    digitalWrite(PD_SCK, LOW);
  }
  
  /* Number is returned as a 24bit 2's compliment but we need to 
     convert it to convert to 32 bit singed integer */
  if (ConversionData >= 0x800000)
    ConversionData = ConversionData | 0xFF000000L;
  
  return ConversionData ;
}