/*
 * EEPROM Write
 *
 * Stores values read from analog input 0 into the EEPROM.
 * These values will stay in the EEPROM when the board is
 * turned off and may be retrieved later by another sketch.
 *
 * This example code is in the public domain.
 * https://github.com/esp8266/Arduino/blob/master/libraries/EEPROM/examples/eeprom_write/eeprom_write.ino
 */

#include <EEPROM.h>

// the current address in the EEPROM (i.e. which byte
// we're going to write to next)
int address = 0;

void setup()
{
  EEPROM.begin(512);
}

void loop()
{
  // need to divide by 4 because analog inputs range from
  // 0 to 1023 and each byte of the EEPROM can only hold a
  // value from 0 to 255.
  int val = analogRead(A0) / 4;

  // write the value to the appropriate byte of the EEPROM.
  // these values will remain there when the board is
  // turned off.
  EEPROM.write(address, val);

  // advance to the next address.  there are 512 bytes in
  // the EEPROM, so go back to 0 when we hit 512.
  // save all changes to the flash.
  address = address + 1;
  if (address == 512)
  {
    address = 0;
    EEPROM.commit();
  }

  delay(100);
}
