/*
 * Decompiled with CFR 0.152.
 */
package com.wch.wchusbdriver;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.Toast;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CH34xAndroidDriver {
    public static final String TAG = "123456789";
    private UsbManager mUsbmanager;
    private PendingIntent mPendingIntent;
    private UsbDevice mUsbDevice;
    private UsbInterface mInterface;
    private UsbEndpoint mCtrlPoint;
    private UsbEndpoint mBulkInPoint;
    private UsbEndpoint mBulkOutPoint;
    private UsbDeviceConnection mDeviceConnection;
    private Context mContext;
    private String mString;
    private boolean BroadcastFlag = false;
    public boolean READ_ENABLE = false;
    public read_thread readThread;
    private byte[] readBuffer;
    private byte[] usbdata;
    private int writeIndex = 0;
    private int readIndex = 0;
    private int readcount;
    private int totalBytes;
    private ArrayList<String> DeviceNum = new ArrayList();
    protected final Object ReadQueueLock = new Object();
    protected final Object WriteQueueLock = new Object();
    private int DeviceCount;
    private int mBulkPacketSize;
    final int maxnumbytes = 65536;
    public int WriteTimeOutMillis;
    public int ReadTimeOutMillis;
    private int DEFAULT_TIMEOUT = 500;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                return;
            }
            if (CH34xAndroidDriver.this.mString.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice localUsbDevice = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        CH34xAndroidDriver.this.OpenUsbDevice(localUsbDevice);
                    } else {
                        Toast.makeText((Context)CH34xAndroidDriver.this.mContext, (CharSequence)"Deny USB Permission", (int)0).show();
                        Log.d((String)CH34xAndroidDriver.TAG, (String)"permission denied");
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                Toast.makeText((Context)CH34xAndroidDriver.this.mContext, (CharSequence)"Disconnect", (int)0).show();
                CH34xAndroidDriver.this.CloseDevice();
            } else {
                Log.d((String)CH34xAndroidDriver.TAG, (String)"......");
            }
        }
    };

    public CH34xAndroidDriver(UsbManager manager, Context context, String AppName) {
        this.readBuffer = new byte[65536];
        this.usbdata = new byte[1024];
        this.mUsbmanager = manager;
        this.mContext = context;
        this.mString = AppName;
        this.WriteTimeOutMillis = 10000;
        this.ReadTimeOutMillis = 10000;
        this.ArrayAddDevice("1a86:7523");
        this.ArrayAddDevice("1a86:5523");
    }

    private void ArrayAddDevice(String str) {
        this.DeviceNum.add(str);
        this.DeviceCount = this.DeviceNum.size();
    }

    public boolean SetTimeOut(int WriteTimeOut, int ReadTimeOut) {
        this.WriteTimeOutMillis = WriteTimeOut;
        this.ReadTimeOutMillis = ReadTimeOut;
        return true;
    }

    public synchronized void OpenUsbDevice(UsbDevice mDevice) {
        UsbDeviceConnection localObject;
        if (mDevice == null) {
            return;
        }
        UsbInterface intf = this.getUsbInterface(mDevice);
        if (mDevice != null && intf != null && (localObject = this.mUsbmanager.openDevice(mDevice)) != null && localObject.claimInterface(intf, true)) {
            this.mUsbDevice = mDevice;
            this.mDeviceConnection = localObject;
            this.mInterface = intf;
            if (!this.enumerateEndPoint(intf)) {
                return;
            }
            Toast.makeText((Context)this.mContext, (CharSequence)"Device Has Attached to Android", (int)1).show();
            if (!this.READ_ENABLE) {
                this.READ_ENABLE = true;
                this.readThread = new read_thread(this.mBulkInPoint, this.mDeviceConnection);
                this.readThread.start();
            }
            return;
        }
    }

    public synchronized void CloseDevice() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mDeviceConnection != null) {
            if (this.mInterface != null) {
                this.mDeviceConnection.releaseInterface(this.mInterface);
                this.mInterface = null;
            }
            this.mDeviceConnection.close();
        }
        if (this.mUsbDevice != null) {
            this.mUsbDevice = null;
        }
        if (this.mUsbmanager != null) {
            this.mUsbmanager = null;
        }
        if (this.READ_ENABLE) {
            this.READ_ENABLE = false;
        }
        if (this.BroadcastFlag) {
            this.mContext.unregisterReceiver(this.mUsbReceiver);
            this.BroadcastFlag = false;
        }
    }

    public boolean UsbFeatureSupported() {
        boolean bool = this.mContext.getPackageManager().hasSystemFeature("android.hardware.usb.host");
        return bool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ResumeUsbList() {
        this.mUsbmanager = (UsbManager)this.mContext.getSystemService("usb");
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(this.mString), (int)0);
        HashMap deviceList = this.mUsbmanager.getDeviceList();
        if (deviceList.isEmpty()) {
            Toast.makeText((Context)this.mContext, (CharSequence)"No Device Or Device Not Match", (int)1).show();
            return 2;
        }
        for (UsbDevice localUsbDevice : deviceList.values()) {
            int i = 0;
            while (i < this.DeviceCount) {
                if (String.format("%04x:%04x", localUsbDevice.getVendorId(), localUsbDevice.getProductId()).equals(this.DeviceNum.get(i))) {
                    IntentFilter filter = new IntentFilter(this.mString);
                    filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.mContext.registerReceiver(this.mUsbReceiver, filter);
                    this.BroadcastFlag = true;
                    if (this.mUsbmanager.hasPermission(localUsbDevice)) {
                        this.OpenUsbDevice(localUsbDevice);
                    } else {
                        BroadcastReceiver broadcastReceiver = this.mUsbReceiver;
                        synchronized (broadcastReceiver) {
                            this.mUsbmanager.requestPermission(localUsbDevice, this.mPendingIntent);
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"String.format not match");
                }
                ++i;
            }
        }
        return 0;
    }

    public boolean isConnected() {
        return this.mUsbDevice != null && this.mInterface != null && this.mDeviceConnection != null;
    }

    protected UsbDevice getUsbDevice() {
        return this.mUsbDevice;
    }

    public int Uart_Control_Out(int request, int value, int index) {
        int retval = 0;
        retval = this.mDeviceConnection.controlTransfer(64, request, value, index, null, 0, this.DEFAULT_TIMEOUT);
        return retval;
    }

    public int Uart_Control_In(int request, int value, int index, byte[] buffer, int length) {
        int retval = 0;
        retval = this.mDeviceConnection.controlTransfer(192, request, value, index, buffer, length, this.DEFAULT_TIMEOUT);
        return retval;
    }

    private int Uart_Set_Handshake(int control) {
        return this.Uart_Control_Out(164, ~control, 0);
    }

    public int Uart_Tiocmset(int set, int clear) {
        int control = 0;
        if ((set & 4) == 4) {
            control |= 0x40;
        }
        if ((set & 2) == 2) {
            control |= 0x20;
        }
        if ((clear & 4) == 4) {
            control &= 0xFFFFFFBF;
        }
        if ((clear & 2) == 2) {
            control &= 0xFFFFFFDF;
        }
        return this.Uart_Set_Handshake(control);
    }

    public boolean UartInit() {
        int size = 8;
        byte[] buffer = new byte[size];
        this.Uart_Control_Out(161, 0, 0);
        int ret = this.Uart_Control_In(95, 0, 0, buffer, 2);
        if (ret < 0) {
            return false;
        }
        this.Uart_Control_Out(154, 4882, 55682);
        this.Uart_Control_Out(154, 3884, 4);
        ret = this.Uart_Control_In(149, 9496, 0, buffer, 2);
        if (ret < 0) {
            return false;
        }
        this.Uart_Control_Out(154, 10023, 0);
        this.Uart_Control_Out(164, 255, 0);
        return true;
    }

    public boolean SetConfig(int baudRate, byte dataBit, byte stopBit, byte parity, byte flowControl) {
        int value = 0;
        int index = 0;
        int valueHigh = 0;
        int valueLow = 0;
        int indexHigh = 0;
        int indexLow = 0;
        switch (parity) {
            case 0: {
                valueHigh = 0;
                break;
            }
            case 1: {
                valueHigh = (char)(valueHigh | 8);
                break;
            }
            case 2: {
                valueHigh = (char)(valueHigh | 0x18);
                break;
            }
            case 3: {
                valueHigh = (char)(valueHigh | 0x28);
                break;
            }
            case 4: {
                valueHigh = (char)(valueHigh | 0x38);
                break;
            }
            default: {
                valueHigh = 0;
            }
        }
        if (stopBit == 2) {
            valueHigh = (char)(valueHigh | 4);
        }
        switch (dataBit) {
            case 5: {
                valueHigh = (char)(valueHigh | 0);
                break;
            }
            case 6: {
                valueHigh = (char)(valueHigh | 1);
                break;
            }
            case 7: {
                valueHigh = (char)(valueHigh | 2);
                break;
            }
            case 8: {
                valueHigh = (char)(valueHigh | 3);
                break;
            }
            default: {
                valueHigh = (char)(valueHigh | 3);
            }
        }
        valueHigh = (char)(valueHigh | 0xC0);
        valueLow = 156;
        value |= valueLow;
        value |= valueHigh << 8;
        switch (baudRate) {
            case 50: {
                indexLow = 0;
                indexHigh = 22;
                break;
            }
            case 75: {
                indexLow = 0;
                indexHigh = 100;
                break;
            }
            case 110: {
                indexLow = 0;
                indexHigh = 150;
                break;
            }
            case 135: {
                indexLow = 0;
                indexHigh = 169;
                break;
            }
            case 150: {
                indexLow = 0;
                indexHigh = 178;
                break;
            }
            case 300: {
                indexLow = 0;
                indexHigh = 217;
                break;
            }
            case 600: {
                indexLow = 1;
                indexHigh = 100;
                break;
            }
            case 1200: {
                indexLow = 1;
                indexHigh = 178;
                break;
            }
            case 1800: {
                indexLow = 1;
                indexHigh = 204;
                break;
            }
            case 2400: {
                indexLow = 1;
                indexHigh = 217;
                break;
            }
            case 4800: {
                indexLow = 2;
                indexHigh = 100;
                break;
            }
            case 9600: {
                indexLow = 2;
                indexHigh = 178;
                break;
            }
            case 19200: {
                indexLow = 2;
                indexHigh = 217;
                break;
            }
            case 38400: {
                indexLow = 3;
                indexHigh = 100;
                break;
            }
            case 57600: {
                indexLow = 3;
                indexHigh = 152;
                break;
            }
            case 115200: {
                indexLow = 3;
                indexHigh = 204;
                break;
            }
            case 230400: {
                indexLow = 3;
                indexHigh = 230;
                break;
            }
            case 460800: {
                indexLow = 3;
                indexHigh = 243;
                break;
            }
            case 500000: {
                indexLow = 3;
                indexHigh = 244;
                break;
            }
            case 921600: {
                indexLow = 7;
                indexHigh = 243;
                break;
            }
            case 1000000: {
                indexLow = 3;
                indexHigh = 250;
                break;
            }
            case 2000000: {
                indexLow = 3;
                indexHigh = 253;
                break;
            }
            case 3000000: {
                indexLow = 3;
                indexHigh = 254;
                break;
            }
            default: {
                indexLow = 2;
                indexHigh = 178;
            }
        }
        index |= 0x88 | indexLow;
        this.Uart_Control_Out(161, value, index |= indexHigh << 8);
        if (flowControl == 1) {
            this.Uart_Tiocmset(6, 0);
        }
        return true;
    }

    public int ReadData(char[] data, int length) {
        if (length < 1 || this.totalBytes == 0) {
            int mLen = 0;
            return mLen;
        }
        if (length > this.totalBytes) {
            length = this.totalBytes;
        }
        this.totalBytes -= length;
        int mLen = length;
        int count = 0;
        while (count < length) {
            data[count] = (char)this.readBuffer[this.readIndex];
            ++this.readIndex;
            this.readIndex %= 65536;
            ++count;
        }
        return mLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadData(byte[] data, int length, int timeoutMillis) throws IOException {
        int totalBytesRead;
        if (this.mBulkInPoint == null) {
            return -1;
        }
        Object object = this.ReadQueueLock;
        synchronized (object) {
            int readAmt = Math.min(length, this.mBulkPacketSize);
            totalBytesRead = this.mDeviceConnection.bulkTransfer(this.mBulkInPoint, data, readAmt, timeoutMillis);
        }
        if (totalBytesRead < 0) {
            throw new IOException("Expected Over 0 Byte");
        }
        return totalBytesRead;
    }

    public int WriteData(byte[] buf, int length) throws IOException {
        int mLen = 0;
        mLen = this.WriteData(buf, length, this.WriteTimeOutMillis);
        if (mLen < 0) {
            throw new IOException("Expected Write Actual Bytes");
        }
        return mLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int WriteData(byte[] buf, int length, int timeoutMillis) {
        offset = 0;
        HasWritten = 0;
        odd_len = length;
        if (this.mBulkOutPoint != null) ** GOTO lbl25
        return -1;
lbl-1000:
        // 1 sources

        {
            var7_7 = this.WriteQueueLock;
            synchronized (var7_7) {
                block7: {
                    mLen = Math.min(odd_len, this.mBulkPacketSize);
                    arrayOfByte = new byte[mLen];
                    if (offset == 0) {
                        System.arraycopy(buf, 0, arrayOfByte, 0, mLen);
                    } else {
                        System.arraycopy(buf, offset, arrayOfByte, 0, mLen);
                    }
                    HasWritten = this.mDeviceConnection.bulkTransfer(this.mBulkOutPoint, arrayOfByte, mLen, timeoutMillis);
                    if (HasWritten >= 0) break block7;
                    return -2;
                }
                offset += HasWritten;
                odd_len -= HasWritten;
            }
lbl25:
            // 2 sources

            ** while (offset < length)
        }
lbl26:
        // 1 sources

        return offset;
    }

    private boolean enumerateEndPoint(UsbInterface sInterface) {
        if (sInterface == null) {
            return false;
        }
        int i = 0;
        while (i < sInterface.getEndpointCount()) {
            UsbEndpoint endPoint = sInterface.getEndpoint(i);
            if (endPoint.getType() == 2 && endPoint.getMaxPacketSize() == 32) {
                if (endPoint.getDirection() == 128) {
                    this.mBulkInPoint = endPoint;
                } else {
                    this.mBulkOutPoint = endPoint;
                }
                this.mBulkPacketSize = endPoint.getMaxPacketSize();
            } else if (endPoint.getType() == 0) {
                this.mCtrlPoint = endPoint;
            }
            ++i;
        }
        return true;
    }

    private UsbInterface getUsbInterface(UsbDevice paramUsbDevice) {
        if (this.mDeviceConnection != null) {
            if (this.mInterface != null) {
                this.mDeviceConnection.releaseInterface(this.mInterface);
                this.mInterface = null;
            }
            this.mDeviceConnection.close();
            this.mUsbDevice = null;
            this.mInterface = null;
        }
        if (paramUsbDevice == null) {
            return null;
        }
        int i = 0;
        while (i < paramUsbDevice.getInterfaceCount()) {
            UsbInterface intf = paramUsbDevice.getInterface(i);
            if (intf.getInterfaceClass() == 255 && intf.getInterfaceSubclass() == 1 && intf.getInterfaceProtocol() == 2) {
                return intf;
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ int access$2(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.totalBytes;
    }

    static /* synthetic */ byte[] access$3(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.usbdata;
    }

    static /* synthetic */ void access$4(CH34xAndroidDriver cH34xAndroidDriver, int n) {
        cH34xAndroidDriver.readcount = n;
    }

    static /* synthetic */ int access$5(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.readcount;
    }

    static /* synthetic */ byte[] access$6(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.readBuffer;
    }

    static /* synthetic */ int access$7(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.writeIndex;
    }

    static /* synthetic */ void access$8(CH34xAndroidDriver cH34xAndroidDriver, int n) {
        cH34xAndroidDriver.writeIndex = n;
    }

    static /* synthetic */ int access$9(CH34xAndroidDriver cH34xAndroidDriver) {
        return cH34xAndroidDriver.readIndex;
    }

    static /* synthetic */ void access$10(CH34xAndroidDriver cH34xAndroidDriver, int n) {
        cH34xAndroidDriver.totalBytes = n;
    }

    public final class UartCmd {
        public static final int VENDOR_WRITE_TYPE = 64;
        public static final int VENDOR_READ_TYPE = 192;
        public static final int VENDOR_READ = 149;
        public static final int VENDOR_WRITE = 154;
        public static final int VENDOR_SERIAL_INIT = 161;
        public static final int VENDOR_MODEM_OUT = 164;
        public static final int VENDOR_VERSION = 95;
    }

    public final class UartIoBits {
        public static final int UART_BIT_RTS = 64;
        public static final int UART_BIT_DTR = 32;
    }

    public final class UartModem {
        public static final int TIOCM_LE = 1;
        public static final int TIOCM_DTR = 2;
        public static final int TIOCM_RTS = 4;
        public static final int TIOCM_ST = 8;
        public static final int TIOCM_SR = 16;
        public static final int TIOCM_CTS = 32;
        public static final int TIOCM_CAR = 64;
        public static final int TIOCM_RNG = 128;
        public static final int TIOCM_DSR = 256;
        public static final int TIOCM_CD = 64;
        public static final int TIOCM_RI = 128;
        public static final int TIOCM_OUT1 = 8192;
        public static final int TIOCM_OUT2 = 16384;
        public static final int TIOCM_LOOP = 32768;
    }

    public final class UartState {
        public static final int UART_STATE = 0;
        public static final int UART_OVERRUN_ERROR = 1;
        public static final int UART_PARITY_ERROR = 2;
        public static final int UART_FRAME_ERROR = 6;
        public static final int UART_RECV_ERROR = 2;
        public static final int UART_STATE_TRANSIENT_MASK = 7;
    }

    public final class UsbType {
        public static final int USB_TYPE_VENDOR = 64;
        public static final int USB_RECIP_DEVICE = 0;
        public static final int USB_DIR_OUT = 0;
        public static final int USB_DIR_IN = 128;
    }

    private class read_thread
    extends Thread {
        UsbEndpoint endpoint;
        UsbDeviceConnection mConn;

        read_thread(UsbEndpoint point, UsbDeviceConnection con) {
            this.endpoint = point;
            this.mConn = con;
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ** GOTO lbl31
            {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                do {
                    if (CH34xAndroidDriver.access$2(CH34xAndroidDriver.this) > 65473) continue block5;
                    var1_1 = CH34xAndroidDriver.this.ReadQueueLock;
                    synchronized (var1_1) {
                        if (this.endpoint != null) {
                            CH34xAndroidDriver.access$4(CH34xAndroidDriver.this, this.mConn.bulkTransfer(this.endpoint, CH34xAndroidDriver.access$3(CH34xAndroidDriver.this), 64, CH34xAndroidDriver.this.ReadTimeOutMillis));
                            if (CH34xAndroidDriver.access$5(CH34xAndroidDriver.this) > 0) {
                                count = 0;
                                while (count < CH34xAndroidDriver.access$5(CH34xAndroidDriver.this)) {
                                    CH34xAndroidDriver.access$6((CH34xAndroidDriver)CH34xAndroidDriver.this)[CH34xAndroidDriver.access$7((CH34xAndroidDriver)CH34xAndroidDriver.this)] = CH34xAndroidDriver.access$3(CH34xAndroidDriver.this)[count];
                                    v0 = CH34xAndroidDriver.this;
                                    CH34xAndroidDriver.access$8(v0, CH34xAndroidDriver.access$7(v0) + 1);
                                    v1 = CH34xAndroidDriver.this;
                                    CH34xAndroidDriver.access$8(v1, CH34xAndroidDriver.access$7(v1) % 65536);
                                    ++count;
                                }
                                if (CH34xAndroidDriver.access$7(CH34xAndroidDriver.this) >= CH34xAndroidDriver.access$9(CH34xAndroidDriver.this)) {
                                    CH34xAndroidDriver.access$10(CH34xAndroidDriver.this, CH34xAndroidDriver.access$7(CH34xAndroidDriver.this) - CH34xAndroidDriver.access$9(CH34xAndroidDriver.this));
                                } else {
                                    CH34xAndroidDriver.access$10(CH34xAndroidDriver.this, 65536 - CH34xAndroidDriver.access$9(CH34xAndroidDriver.this) + CH34xAndroidDriver.access$7(CH34xAndroidDriver.this));
                                }
                            }
                        }
                    }
lbl31:
                    // 3 sources

                } while (CH34xAndroidDriver.this.READ_ENABLE);
            }
        }
    }
}

